//
//  PullView.m
//  HelloWorld
//
//  Created by Erica Sadun on 7/21/11.
//  Copyright 2011 Up To No Good, Inc. All rights reserved.
//

#import "PullView.h"


#pragma mark Pull-out-an-Image View for use in scroll view

#define DX(p1, p2)	(p2.x - p1.x)
#define DY(p1, p2)	(p2.y - p1.y)

#define SWIPE_DRAG_MIN 16
#define DRAGLIMIT_MAX 12 

typedef enum {
	TouchUnknown,
	TouchSwipeLeft,
	TouchSwipeRight,
	TouchSwipeUp,
	TouchSwipeDown,
} SwipeTypes;

@implementation PullView
- (id) initWithImage: (UIImage *) anImage
{
	if (self = [super initWithImage:anImage])
	{
		self.userInteractionEnabled = YES;
		UIPanGestureRecognizer *pan = [[UIPanGestureRecognizer alloc] initWithTarget:self action:@selector(handlePan:)];
        pan.delegate = self;
		self.gestureRecognizers = [NSArray arrayWithObjects: pan, nil];
	}
	return self;
}

- (BOOL)gestureRecognizer:(UIGestureRecognizer *)gestureRecognizer shouldRecognizeSimultaneouslyWithGestureRecognizer:(UIGestureRecognizer *)otherGestureRecognizer
{
    return YES;
}

- (void) handlePan: (UIPanGestureRecognizer *) uigr
{
	// Działaj tylko z widokami nadrzędnymi widoku przewijanego.
	if (![self.superview isKindOfClass:[UIScrollView class]]) return;
    
	// Wyodrębnij widoki nadrzędne.
	UIView *supersuper = self.superview.superview;
	UIScrollView *scrollView = (UIScrollView *) self.superview;
	
	// Obliczenie położenia dotknięcia.
	CGPoint touchLocation = [uigr locationInView:supersuper];
	
	if (uigr.state == UIGestureRecognizerStateBegan) 
	{
		// Inicjalizacja procedury rozpoznawania gestów.
		gestureWasHandled = NO;
		pointCount = 1;
		startPoint = touchLocation;
	}
	
    if (uigr.state == UIGestureRecognizerStateChanged) 
    {
        pointCount++;
        
        // Obliczenie miejsca wystąpienia gestu machnięcia.
        float dx = DX(touchLocation, startPoint);
        float dy = DY(touchLocation, startPoint);
        
        // Wykrycie znanych typów machnięcia.
        BOOL finished = YES;
        if ((dx > SWIPE_DRAG_MIN) && (ABS(dy) < DRAGLIMIT_MAX)) // Poziome w lewo.
            touchtype = TouchSwipeLeft;
        else if ((-dx > SWIPE_DRAG_MIN) && (ABS(dy) < DRAGLIMIT_MAX)) // Poziome w prawo.
            touchtype = TouchSwipeRight;
        else if ((dy > SWIPE_DRAG_MIN) && (ABS(dx) < DRAGLIMIT_MAX)) // Pionowe w górę.
            touchtype = TouchSwipeUp;
        else if ((-dy > SWIPE_DRAG_MIN) && (ABS(dx) < DRAGLIMIT_MAX)) // Pionowe w dół.
            touchtype = TouchSwipeDown;
        else
            finished = NO;
        
        // W przypadku nieobsłużonego gestu machnięcia w dół wygeneruj nowy widok możliwy do przeciągnięcia.
        if (!gestureWasHandled && finished && (touchtype == TouchSwipeDown))
        {
            dv = [[DragView alloc] initWithImage:self.image];
            dv.center = touchLocation;
            dv.backgroundColor = [UIColor clearColor];
            [supersuper addSubview:dv];			
            scrollView.scrollEnabled = NO;
            gestureWasHandled = YES;
        }
        else if (gestureWasHandled)
        {
            // Zezwolenie na kontynuację przeciągania po wykryciu gestu.
            dv.center = touchLocation;
        }
    }
    
    if (uigr.state == UIGestureRecognizerStateEnded)
    {
        // Zagwarantowanie, że widok przewijany znów będzie mógł być przewijany.
        if (gestureWasHandled)
            scrollView.scrollEnabled = YES;
    }
}
@end 



